' Enumration personnalise.
Enum EmpType As Byte
    Manager = 10
    Grunt = 1
    Contractor = 100
	VP = 9
End Enum

' Et voici une structure utilisant cette numration.
Structure EMPLOYEE
    ' Champs.
    Public title As EmpType
    Public name As String
    Public deptID As Short

    ' Construction.
    Public Sub New(ByVal et As EmpType, ByVal n As String, ByVal d As Short)
        title = et
        name = n
        deptID = d
    End Sub
End Structure

Module Module1

    Sub DisplayEmpStats(ByVal e As EMPLOYEE)
        Console.WriteLine("Voici les renseignements sur {0} :", e.name)
        Console.WriteLine("Nom du service : {0}", e.deptID)
        Console.WriteLine("Fonction : {0}", e.title)
    End Sub

    Sub UnboxThisEmployee(ByVal o As Object)
        Dim temp As EMPLOYEE = o
        Console.WriteLine(temp.name + " est vivant !")
    End Sub

    Sub Main()
        ' Cration et mise en forme de Fred.
        Dim fred As EMPLOYEE
        fred.deptID = 40
        fred.name = "Fred"
        fred.title = EmpType.Grunt

        ' Cration et mise en forme de Mary en utilisant un constructeur.
        Dim mary As EMPLOYEE = New EMPLOYEE(EmpType.VP, "Mary", 10)

        ' Afficher les renseignements sur les employs.
        DisplayEmpStats(mary)
        DisplayEmpStats(fred)

        ' Crer un employ.
        Dim stan As EMPLOYEE = New EMPLOYEE(EmpType.Grunt, "Stan", 10)
        Dim stanInBox As Object = stan

        ' Envoyer vers une fonction prototype avec un objet
        UnboxThisEmployee(stanInBox)
    End Sub
End Module
